<?php
//search
require 'db.php';

$q = trim($_GET['q'] ?? '');
$categoryId = $_GET['category'] ?? '';
$minPrice   = $_GET['min_price'] ?? '';
$maxPrice   = $_GET['max_price'] ?? '';
$condition  = $_GET['condition'] ?? '';

// Fetch categories
$categories = $pdo->query("SELECT id, name FROM categories ORDER BY name ASC")->fetchAll();

// Build query
$where = ["p.is_active = 1"];
$params = [];

if ($q !== '') {
    $where[] = "(p.name LIKE :term OR p.description LIKE :term OR p.tags LIKE :term)";
    $params[':term'] = "%$q%";
}

if ($categoryId !== '') {
    $where[] = "p.category_id = :cat";
    $params[':cat'] = (int)$categoryId;
}

if ($minPrice !== '') {
    $where[] = "p.price >= :min_price";
    $params[':min_price'] = (float)$minPrice;
}

if ($maxPrice !== '') {
    $where[] = "p.price <= :max_price";
    $params[':max_price'] = (float)$maxPrice;
}

if ($condition !== '') {
    $where[] = "p.condition = :cond";
    $params[':cond'] = $condition;
}

$sql = "
    SELECT p.*, c.name AS category_name
    FROM products p
    LEFT JOIN categories c ON p.category_id = c.id
    WHERE " . implode(" AND ", $where) . "
    ORDER BY p.created_at DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll();

$pageTitle = "Search – CompNet";
require 'partials/header.php';
?>

<h1>Search Products</h1>

<form action="/search" method="get" class="filter-form">
    <input type="text" name="q" placeholder="Search…" value="<?= htmlspecialchars($q) ?>">

    <select name="category">
        <option value="">All Categories</option>
        <?php foreach ($categories as $cat): ?>
            <option value="<?= $cat['id'] ?>" <?= $cat['id'] == $categoryId ? 'selected' : '' ?>>
                <?= htmlspecialchars($cat['name']) ?>
            </option>
        <?php endforeach; ?>
    </select>

    <input type="number" name="min_price" placeholder="Min Price"
           value="<?= htmlspecialchars($minPrice) ?>">

    <input type="number" name="max_price" placeholder="Max Price"
           value="<?= htmlspecialchars($maxPrice) ?>">

    <select name="condition">
        <option value="">Any Condition</option>
        <option value="new"     <?= $condition === 'new' ? 'selected' : '' ?>>New</option>
        <option value="ex-uk"   <?= $condition === 'ex-uk' ? 'selected' : '' ?>>Ex-UK</option>
        <option value="refurb"  <?= $condition === 'refurb' ? 'selected' : '' ?>>Refurbished</option>
        <option value="used"    <?= $condition === 'used' ? 'selected' : '' ?>>Used</option>
    </select>

    <button type="submit" class="admin-btn-secondary">Search</button>
</form>

<div class="product-grid">
    <?php foreach ($products as $p): ?>
        <article class="product-card">
            <div class="product-thumb">
                <?php if ($p['main_image']): ?>
                    <img src="<?= htmlspecialchars($p['main_image']) ?>" alt="">
                <?php endif; ?>
            </div>

            <div class="product-title"><?= htmlspecialchars($p['name']) ?></div>

            <div class="product-meta">
                <?= htmlspecialchars($p['short_meta'] ?? '') ?>
            </div>

            <div class="product-price">
                <?php if ($p['old_price']): ?>
                    <span>KSh <?= number_format($p['old_price']) ?></span>
                <?php endif; ?>
                KSh <?= number_format($p['price']) ?>
            </div>

            <div class="product-actions">
                <a href="/product/<?= $p['id'] ?>" class="quick">View</a>
                <a href="/cart.php?action=add&id=<?= $p['id'] ?>&return=<?= urlencode($_SERVER['REQUEST_URI']) ?>"
                   class="add">Add</a>
            </div>
        </article>
    <?php endforeach; ?>
</div>

<?php require 'partials/footer.php'; ?>
