<?php
//product
require 'db.php';

// Get product ID from URL (/product/123)
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$stmt = $pdo->prepare("
    SELECT p.*, c.name AS category_name, c.slug AS category_slug
    FROM products p
    LEFT JOIN categories c ON p.category_id = c.id
    WHERE p.id = :id AND p.is_active = 1
");
$stmt->execute([':id' => $id]);
$product = $stmt->fetch();

if (!$product) {
    http_response_code(404);
    $pageTitle = "Product Not Found – CompNet";
    require 'partials/header.php';
    echo "<h1>Product not found</h1>";
    require 'partials/footer.php';
    exit;
}

$pageTitle = $product['name'] . " – CompNet";
require 'partials/header.php';
?>

<div class="product-page">

    <div class="product-image-large">
        <?php if ($product['main_image']): ?>
            <img src="<?= htmlspecialchars($product['main_image']) ?>" alt="">
        <?php else: ?>
            <div class="placeholder-lg"></div>
        <?php endif; ?>
    </div>

    <div class="product-info">
        <h1><?= htmlspecialchars($product['name']) ?></h1>

        <p class="muted">
            Category:
            <a href="/category/<?= htmlspecialchars($product['category_slug']) ?>">
                <?= htmlspecialchars($product['category_name']) ?>
            </a>
        </p>

        <div class="product-price-lg">
            <?php if (!empty($product['old_price'])): ?>
                <span>KSh <?= number_format($product['old_price']) ?></span>
            <?php endif; ?>
            KSh <?= number_format($product['price']) ?>
        </div>

        <?php if ($product['short_meta']): ?>
            <p class="muted"><?= htmlspecialchars($product['short_meta']) ?></p>
        <?php endif; ?>

        <a href="/cart.php?action=add&id=<?= $product['id'] ?>&return=<?= urlencode($_SERVER['REQUEST_URI']) ?>"
           class="btn-primary"
           style="margin-top:12px;display:inline-block;text-decoration:none;">
            Add to Cart
        </a>

        <div style="margin-top:16px;">
            <?php if ($product['condition']): ?>
                <span class="pill"><?= htmlspecialchars(ucfirst($product['condition'])) ?></span>
            <?php endif; ?>

            <?php if ($product['tags']): ?>
                <?php foreach (explode(',', $product['tags']) as $tag): ?>
                    <span class="pill"><?= htmlspecialchars(trim($tag)) ?></span>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <?php if ($product['description']): ?>
            <h3 style="margin-top:22px;">Description</h3>
            <p><?= nl2br(htmlspecialchars($product['description'])) ?></p>
        <?php endif; ?>
    </div>

</div>

<?php require 'partials/footer.php'; ?>
