<?php
// partials/header.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Default page title
if (!isset($pageTitle)) {
    $pageTitle = "CompNet Shop";
}

// Cart item count
$cartCount = 0;
if (!empty($_SESSION['cart']) && is_array($_SESSION['cart'])) {
    $cartCount = array_sum($_SESSION['cart']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>

<div class="top-bar">
    Fast Delivery across Kenya · Call/WhatsApp: +254 722-356620 / 722648222 / 705542400 · Shop genuine laptops & accessories
</div>

<header>
    <div class="nav-container">
        <a href="/" class="logo">CompNet<span>(CASL)</span></a>

        <nav class="nav-links">
            <a href="/">Home</a>
            <a href="/search">Search</a>
            <a href="/category/laptops">Laptops</a>
            <a href="/category/accessories">Accessories</a>
            <a href="/category/networking">Networking</a>
        </nav>

        <form class="search" action="/search" method="get">
            <input type="text" name="q" placeholder="Search laptops, accessories, printers...">
            <button type="submit">Search</button>
        </form>

        <div class="icons">
            <div class="pill">Sign In</div>
            <a href="/cart" class="pill">Cart (<?= $cartCount ?>)</a>
            <a href="/admin" class="pill">Admin</a>
        </div>
    </div>
</header>

<main>
    <?php if (!empty($_SESSION['flash'])): ?>
        <div class="flash flash-<?= htmlspecialchars($_SESSION['flash']['type']) ?>">
            <?= htmlspecialchars($_SESSION['flash']['message']) ?>
        </div>
        <?php unset($_SESSION['flash']); ?>
    <?php endif; ?>
