<?php
$pageTitle = "CompNet Shop – Home";
require 'db.php';

// Sidebar categories
$categories = $pdo->query("
    SELECT id, name, slug
    FROM categories
    ORDER BY name ASC
")->fetchAll(PDO::FETCH_ASSOC);

// Featured products (flagged as featured)
$featuredProducts = $pdo->query("
    SELECT p.*, c.name AS category_name, c.slug AS category_slug
    FROM products p
    LEFT JOIN categories c ON p.category_id = c.id
    WHERE p.is_active = 1 AND p.is_featured = 1
    ORDER BY p.created_at DESC
    LIMIT 8
")->fetchAll(PDO::FETCH_ASSOC);

// Helper: latest N products in a category by slug
function latestByCategorySlug(PDO $pdo, string $slug, int $limit = 4): array {
    $limit = max(1, min($limit, 20));
    $sql = "
        SELECT p.*, c.name AS category_name, c.slug AS category_slug
        FROM products p
        JOIN categories c ON p.category_id = c.id
        WHERE p.is_active = 1
          AND c.slug = :slug
        ORDER BY p.created_at DESC
        LIMIT $limit
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':slug' => $slug]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Adjust slugs here if your DB uses different ones
$laptopProducts    = latestByCategorySlug($pdo, 'laptops', 4);
$accessoryProducts = latestByCategorySlug($pdo, 'accessories', 4);
$networkProducts   = latestByCategorySlug($pdo, 'networking', 4);

require 'partials/header.php';
?>

<div class="layout">

    <!-- Sidebar categories -->
    <aside class="categories">
        <h3>Categories</h3>
        <ul>
            <?php foreach ($categories as $cat): ?>
                <li>
                    <a href="/category/<?= htmlspecialchars($cat['slug']) ?>">
                        <?= htmlspecialchars($cat['name']) ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    </aside>

    <section class="hero-area">

        <!-- HERO -->
        <div class="hero">
            <div class="hero-text">
                <div class="hero-badges">
                    <div class="hero-badge">Black Friday</div>
                    <div class="hero-badge">Up to 30% OFF</div>
                </div>
                <h1>Premium Laptops for Work, School & Gaming.</h1>
                <p>
                    Shop genuine HP, Dell, Asus, Lenovo and more. Pay on delivery in Nairobi,
                    same-day shipping across Kenya.
                </p>

                <div class="hero-actions">
                    <a href="/category/laptops">
                        <button class="btn-primary">Shop Laptops</button>
                    </a>
                    <a href="#section-featured">
                        <button class="btn-outline">View Daily Deals</button>
                    </a>
                </div>
                <p class="hero-price">
                    From <strong>KSh 18,000</strong> · 12-month warranty on select models
                </p>
            </div>

            <div class="hero-image">
                <div class="product-img"></div>
                <h3>ASUS VivoBook 15 – Core i5, 8GB, 512GB SSD</h3>
                <p>Thin, light and powerful – perfect for students and professionals.</p>
            </div>
        </div>

        <!-- PROMO STRIP -->
        <div class="promo-strip">
            <div class="promo-card">
                <h4>Fast Shipping</h4>
                <span>Within Nairobi same day. Next-day to major towns.</span>
            </div>
            <div class="promo-card">
                <h4>Secure Payment</h4>
                <span>M-PESA, card & bank transfer options.</span>
            </div>
            <div class="promo-card">
                <h4>Warranty Included</h4>
                <span>Up to 12 months on select items.</span>
            </div>
            <div class="promo-card">
                <h4>Expert Support</h4>
                <span>We help you pick the right machine.</span>
            </div>
        </div>

        <!-- FEATURED DEALS -->
        <div class="section-header" id="section-featured">
            <h2>Featured Deals</h2>
            <a href="/search?q=deal">See all deals →</a>
        </div>

        <?php if (empty($featuredProducts)): ?>
            <p class="muted">No featured deals at the moment. Check back soon.</p>
        <?php else: ?>
            <div class="product-grid">
                <?php foreach ($featuredProducts as $p): ?>
                    <article class="product-card">
                        <div class="product-thumb">
                            <?php if (!empty($p['main_image'])): ?>
                                <img src="<?= htmlspecialchars($p['main_image']) ?>" alt="">
                            <?php endif; ?>
                        </div>
                        <div class="product-title"><?= htmlspecialchars($p['name']) ?></div>
                        <div class="product-meta">
                            <?= htmlspecialchars($p['short_meta'] ?? ($p['category_name'] ?? '')) ?>
                        </div>
                        <div class="product-price">
                            <?php if (!empty($p['old_price'])): ?>
                                <span>KSh <?= number_format($p['old_price']) ?></span>
                            <?php endif; ?>
                            KSh <?= number_format($p['price']) ?>
                        </div>
                        <div class="product-actions">
                            <a href="/product/<?= $p['id'] ?>" class="quick">View</a>
                            <a href="/cart?action=add&id=<?= $p['id'] ?>&return=<?= urlencode($_SERVER['REQUEST_URI']) ?>"
                               class="add">
                                Add
                            </a>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <!-- LATEST LAPTOPS -->
        <div class="section-header" style="margin-top:28px;">
            <h2>Latest Laptops</h2>
            <a href="/category/laptops">View all laptops →</a>
        </div>

        <?php if (empty($laptopProducts)): ?>
            <p class="muted">No laptops available yet.</p>
        <?php else: ?>
            <div class="product-grid">
                <?php foreach ($laptopProducts as $p): ?>
                    <article class="product-card">
                        <div class="product-thumb">
                            <?php if (!empty($p['main_image'])): ?>
                                <img src="<?= htmlspecialchars($p['main_image']) ?>" alt="">
                            <?php endif; ?>
                        </div>
                        <div class="product-title"><?= htmlspecialchars($p['name']) ?></div>
                        <div class="product-meta">
                            <?= htmlspecialchars($p['short_meta'] ?? '') ?>
                            <?php if (!empty($p['condition'])): ?>
                                · <?= htmlspecialchars(ucfirst($p['condition'])) ?>
                            <?php endif; ?>
                        </div>
                        <div class="product-price">
                            <?php if (!empty($p['old_price'])): ?>
                                <span>KSh <?= number_format($p['old_price']) ?></span>
                            <?php endif; ?>
                            KSh <?= number_format($p['price']) ?>
                        </div>
                        <div class="product-actions">
                            <a href="/product/<?= $p['id'] ?>" class="quick">View</a>
                            <a href="/cart?action=add&id=<?= $p['id'] ?>&return=<?= urlencode($_SERVER['REQUEST_URI']) ?>"
                               class="add">
                                Add
                            </a>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <!-- LATEST ACCESSORIES -->
        <div class="section-header" style="margin-top:28px;">
            <h2>Latest Accessories</h2>
            <a href="/category/accessories">View all accessories →</a>
        </div>

        <?php if (empty($accessoryProducts)): ?>
            <p class="muted">No accessories available yet.</p>
        <?php else: ?>
            <div class="product-grid">
                <?php foreach ($accessoryProducts as $p): ?>
                    <article class="product-card">
                        <div class="product-thumb">
                            <?php if (!empty($p['main_image'])): ?>
                                <img src="<?= htmlspecialchars($p['main_image']) ?>" alt="">
                            <?php endif; ?>
                        </div>
                        <div class="product-title"><?= htmlspecialchars($p['name']) ?></div>
                        <div class="product-meta">
                            <?= htmlspecialchars($p['short_meta'] ?? '') ?>
                            <?php if (!empty($p['condition'])): ?>
                                · <?= htmlspecialchars(ucfirst($p['condition'])) ?>
                            <?php endif; ?>
                        </div>
                        <div class="product-price">
                            <?php if (!empty($p['old_price'])): ?>
                                <span>KSh <?= number_format($p['old_price']) ?></span>
                            <?php endif; ?>
                            KSh <?= number_format($p['price']) ?>
                        </div>
                        <div class="product-actions">
                            <a href="/product/<?= $p['id'] ?>" class="quick">View</a>
                            <a href="/cart?action=add&id=<?= $p['id'] ?>&return=<?= urlencode($_SERVER['REQUEST_URI']) ?>"
                               class="add">
                                Add
                            </a>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <!-- LATEST NETWORKING -->
        <div class="section-header" style="margin-top:28px;">
            <h2>Latest Networking</h2>
            <a href="/category/networking">View all networking →</a>
        </div>

        <?php if (empty($networkProducts)): ?>
            <p class="muted">No networking equipment available yet.</p>
        <?php else: ?>
            <div class="product-grid">
                <?php foreach ($networkProducts as $p): ?>
                    <article class="product-card">
                        <div class="product-thumb">
                            <?php if (!empty($p['main_image'])): ?>
                                <img src="<?= htmlspecialchars($p['main_image']) ?>" alt="">
                            <?php endif; ?>
                        </div>
                        <div class="product-title"><?= htmlspecialchars($p['name']) ?></div>
                        <div class="product-meta">
                            <?= htmlspecialchars($p['short_meta'] ?? '') ?>
                            <?php if (!empty($p['condition'])): ?>
                                · <?= htmlspecialchars(ucfirst($p['condition'])) ?>
                            <?php endif; ?>
                        </div>
                        <div class="product-price">
                            <?php if (!empty($p['old_price'])): ?>
                                <span>KSh <?= number_format($p['old_price']) ?></span>
                            <?php endif; ?>
                            KSh <?= number_format($p['price']) ?>
                        </div>
                        <div class="product-actions">
                            <a href="/product/<?= $p['id'] ?>" class="quick">View</a>
                            <a href="/cart?action=add&id=<?= $p['id'] ?>&return=<?= urlencode($_SERVER['REQUEST_URI']) ?>"
                               class="add">
                                Add
                            </a>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </section>
</div>

<?php require 'partials/footer.php'; ?>
