<?php
//category
require 'db.php';

$slug = $_GET['slug'] ?? '';

$stmt = $pdo->prepare("SELECT * FROM categories WHERE slug = :slug");
$stmt->execute([':slug' => $slug]);
$category = $stmt->fetch();

if (!$category) {
    http_response_code(404);
    $pageTitle = "Category Not Found – CompNet";
    require 'partials/header.php';
    echo "<h1>Category not found</h1>";
    require 'partials/footer.php';
    exit;
}

$pageTitle = $category['name'] . " – CompNet";

// Filters
$minPrice  = $_GET['min_price'] ?? null;
$maxPrice  = $_GET['max_price'] ?? null;
$condition = $_GET['condition'] ?? '';
$sort      = $_GET['sort'] ?? '';

// Build query
$where = ["p.is_active = 1", "p.category_id = :cid"];
$params = [':cid' => $category['id']];

if ($minPrice !== '' && $minPrice !== null) {
    $where[] = "p.price >= :min_price";
    $params[':min_price'] = (float)$minPrice;
}
if ($maxPrice !== '' && $maxPrice !== null) {
    $where[] = "p.price <= :max_price";
    $params[':max_price'] = (float)$maxPrice;
}
if ($condition !== '') {
    $where[] = "p.condition = :cond";
    $params[':cond'] = $condition;
}

$orderBy = "p.created_at DESC";
if ($sort === 'price_asc') $orderBy = "p.price ASC";
if ($sort === 'price_desc') $orderBy = "p.price DESC";
if ($sort === 'name_asc') $orderBy = "p.name ASC";

$sql = "
    SELECT p.*, c.name AS category_name
    FROM products p
    JOIN categories c ON p.category_id = c.id
    WHERE " . implode(" AND ", $where) . "
    ORDER BY $orderBy
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll();

require 'partials/header.php';
?>

<h1><?= htmlspecialchars($category['name']) ?></h1>
<p class="muted">Browse our latest products in this category.</p>

<form action="/category.php" method="get" class="filter-form">
    <input type="hidden" name="slug" value="<?= htmlspecialchars($slug) ?>">

    <div>
        <label>Min Price</label>
        <input type="number" name="min_price"
               value="<?= htmlspecialchars($minPrice ?? '') ?>">
    </div>

    <div>
        <label>Max Price</label>
        <input type="number" name="max_price"
               value="<?= htmlspecialchars($maxPrice ?? '') ?>">
    </div>

    <div>
        <label>Condition</label>
        <select name="condition">
            <option value="">Any</option>
            <option value="new"     <?= $condition === 'new' ? 'selected' : '' ?>>New</option>
            <option value="ex-uk"   <?= $condition === 'ex-uk' ? 'selected' : '' ?>>Ex-UK</option>
            <option value="refurb"  <?= $condition === 'refurb' ? 'selected' : '' ?>>Refurbished</option>
            <option value="used"    <?= $condition === 'used' ? 'selected' : '' ?>>Used</option>
        </select>
    </div>

    <div>
        <label>Sort By</label>
        <select name="sort">
            <option value="">Newest</option>
            <option value="price_asc"  <?= $sort === 'price_asc' ? 'selected' : '' ?>>Price: Low → High</option>
            <option value="price_desc" <?= $sort === 'price_desc' ? 'selected' : '' ?>>Price: High → Low</option>
            <option value="name_asc"   <?= $sort === 'name_asc' ? 'selected' : '' ?>>Name A→Z</option>
        </select>
    </div>

    <button type="submit" class="admin-btn-secondary">Apply</button>
    <a href="/category/<?= htmlspecialchars($slug) ?>" class="admin-btn-secondary">Clear</a>
</form>

<div class="product-grid">
    <?php foreach ($products as $p): ?>
        <article class="product-card">
            <div class="product-thumb">
                <?php if ($p['main_image']): ?>
                    <img src="<?= htmlspecialchars($p['main_image']) ?>" alt="">
                <?php endif; ?>
            </div>

            <div class="product-title"><?= htmlspecialchars($p['name']) ?></div>
            <div class="product-meta">
                <?= htmlspecialchars($p['short_meta'] ?? '') ?>
            </div>

            <div class="product-price">
                <?php if ($p['old_price']): ?>
                    <span>KSh <?= number_format($p['old_price']) ?></span>
                <?php endif; ?>
                KSh <?= number_format($p['price']) ?>
            </div>

            <div class="product-actions">
                <a href="/product/<?= $p['id'] ?>" class="quick">View</a>
                <a href="/cart.php?action=add&id=<?= $p['id'] ?>&return=<?= urlencode($_SERVER['REQUEST_URI']) ?>"
                   class="add">Add</a>
            </div>
        </article>
    <?php endforeach; ?>
</div>

<?php require 'partials/footer.php'; ?>
