:root {
    --primary: #0070c9;
    --primary-dark: #005199;
    --accent: #ff8800;
    --text: #222;
    --muted: #777;
    --bg: #f5f5f7;
    --card-bg: #ffffff;

    --danger: #b91c1c;
    --success: #16a34a;
    --warning: #f59e0b;
}

/* RESET / BASE */
* {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
    font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
}

body {
    background: var(--bg);
    color: var(--text);
    line-height: 1.5;
    font-size: 14px;
}

a {
    text-decoration: none;
    color: inherit;
}

img {
    max-width: 100%;
    display: block;
}

/* TOP BAR */
.top-bar {
    background: #000;
    color: #fff;
    font-size: 13px;
    padding: 6px 12px;
    text-align: center;
}

/* HEADER / NAV */
header {
    background: #fff;
    box-shadow: 0 1px 4px rgba(0, 0, 0, 0.08);
    position: sticky;
    top: 0;
    z-index: 10;
}

.nav-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 12px 16px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 16px;
}

.logo {
    font-weight: 800;
    font-size: 22px;
    letter-spacing: 0.03em;
    color: var(--primary-dark);
}

.logo span {
    color: var(--accent);
}

.nav-links {
    display: flex;
    gap: 18px;
    font-size: 14px;
    align-items: center;
}

.nav-links a {
    color: #444;
}

.nav-links a:hover {
    color: var(--primary);
}

/* SEARCH BAR (HEADER) */
.search {
    flex: 1;
    max-width: 360px;
    display: flex;
    align-items: center;
    border-radius: 20px;
    overflow: hidden;
    border: 1px solid #ddd;
    background: #fafafa;
}

.search input {
    border: none;
    outline: none;
    padding: 8px 12px;
    flex: 1;
    font-size: 14px;
    background: transparent;
}

.search button {
    border: none;
    padding: 8px 14px;
    cursor: pointer;
    background: var(--primary);
    color: #fff;
    font-size: 14px;
}

/* HEADER ICONS / PILLS */
.icons {
    display: flex;
    gap: 12px;
    align-items: center;
    font-size: 14px;
}

.pill {
    padding: 6px 10px;
    border-radius: 999px;
    border: 1px solid #ddd;
    font-size: 12px;
    cursor: pointer;
    display: inline-block;
}

/* FLASH MESSAGES */
.flash {
    max-width: 1200px;
    margin: 12px auto 0;
    padding: 10px 12px;
    border-radius: 8px;
    font-size: 13px;
}

.flash-success {
    background: #ecfdf3;
    color: #166534;
    border: 1px solid #bbf7d0;
}

.flash-error {
    background: #fef2f2;
    color: #b91c1c;
    border: 1px solid #fecaca;
}

/* MAIN LAYOUT */
main {
    max-width: 1200px;
    margin: 16px auto 40px;
    padding: 0 16px;
}

.layout {
    display: grid;
    grid-template-columns: 230px 1fr;
    gap: 20px;
}

/* CATEGORIES SIDEBAR */
.categories {
    background: #fff;
    border-radius: 10px;
    padding: 12px 0;
    box-shadow: 0 1px 4px rgba(0, 0, 0, 0.06);
}

.categories h3 {
    padding: 0 16px 8px;
    font-size: 15px;
    border-bottom: 1px solid #eee;
    margin-bottom: 4px;
}

.categories ul {
    list-style: none;
    font-size: 14px;
}

.categories li a {
    display: block;
    padding: 6px 16px;
    color: #333;
}

.categories li a:hover {
    background: var(--bg);
    color: var(--primary);
}

/* HERO AREA */
.hero-area {
    display: grid;
    grid-template-rows: auto auto;
    gap: 16px;
}

.hero {
    background: linear-gradient(135deg, #111827, #1e40af);
    border-radius: 18px;
    padding: 24px;
    color: #fff;
    display: grid;
    grid-template-columns: 1.3fr 1fr;
    gap: 16px;
    align-items: center;
    position: relative;
    overflow: hidden;
}

.hero::after {
    content: "";
    position: absolute;
    width: 160px;
    height: 160px;
    border-radius: 50%;
    border: 1px solid rgba(255, 255, 255, 0.2);
    top: -40px;
    right: -40px;
}

.hero-text h1 {
    font-size: 30px;
    margin-bottom: 8px;
}

.hero-text p {
    font-size: 14px;
    max-width: 420px;
    color: #d1d5db;
    margin-bottom: 16px;
}

.hero-badges {
    display: flex;
    flex-wrap: wrap;
    gap: 6px;
    margin-bottom: 16px;
    font-size: 11px;
}

.hero-badge {
    border-radius: 999px;
    border: 1px solid rgba(255, 255, 255, 0.3);
    padding: 4px 8px;
    text-transform: uppercase;
    letter-spacing: 0.06em;
}

.hero-actions {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    align-items: center;
}

.btn-primary {
    background: var(--accent);
    border-radius: 999px;
    padding: 8px 16px;
    border: none;
    cursor: pointer;
    font-size: 14px;
    font-weight: 600;
    color: #111827;
}

.btn-outline {
    background: transparent;
    color: #e5e7eb;
    border-radius: 999px;
    padding: 7px 14px;
    border: 1px solid rgba(229, 231, 235, 0.5);
    font-size: 13px;
    cursor: pointer;
}

.hero-price {
    font-size: 13px;
    color: #9ca3af;
}

.hero-price strong {
    font-size: 18px;
    color: #fff;
}

.hero-image {
    background: radial-gradient(circle at top left, #1d4ed8, transparent 60%);
    border-radius: 14px;
    padding: 18px;
    text-align: center;
    border: 1px solid rgba(255, 255, 255, 0.15);
}

.hero-image .product-img {
    width: 100%;
    max-width: 260px;
    height: 150px;
    margin: 0 auto 8px;
    border-radius: 12px;
    background: linear-gradient(135deg, #0f172a, #111827);
}

/* PROMO STRIP */
.promo-strip {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 10px;
}

.promo-card {
    background: #fff;
    border-radius: 12px;
    padding: 10px 12px;
    display: flex;
    flex-direction: column;
    gap: 2px;
    font-size: 12px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.06);
}

.promo-card h4 {
    font-size: 13px;
    font-weight: 600;
}

.promo-card span {
    color: var(--muted);
}

/* SECTION HEADER */
.section-header {
    margin: 28px 0 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 14px;
}

.section-header h2 {
    font-size: 18px;
}

.section-header a {
    font-size: 13px;
    color: var(--primary);
}

/* PRODUCT GRID */
.product-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(190px, 1fr));
    gap: 14px;
}

.product-card {
    background: var(--card-bg);
    border-radius: 14px;
    padding: 12px;
    box-shadow: 0 1px 4px rgba(0, 0, 0, 0.04);
    display: flex;
    flex-direction: column;
    gap: 6px;
}

.product-thumb {
    height: 150px;
    border-radius: 10px;
    background: linear-gradient(135deg, #e5e7eb, #d1d5db);
    margin-bottom: 8px;
    overflow: hidden;
}

.product-thumb img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.product-title {
    font-size: 14px;
    font-weight: 600;
    min-height: 40px;
}

.product-meta {
    font-size: 11px;
    color: var(--muted);
}

.product-price {
    margin-top: 4px;
    font-size: 14px;
    font-weight: 700;
}

.product-price span {
    font-size: 11px;
    color: var(--muted);
    text-decoration: line-through;
    margin-right: 4px;
}

.product-actions {
    margin-top: 8px;
    display: flex;
    justify-content: space-between;
    gap: 8px;
    font-size: 12px;
}

.product-actions .add,
.product-actions .quick {
    flex: 1;
    border-radius: 999px;
    border: none;
    padding: 6px 0;
    cursor: pointer;
    text-align: center;
    display: inline-block;
}

.product-actions .add {
    background: var(--primary);
    color: #fff;
    font-weight: 600;
}

.product-actions .quick {
    background: #f3f4f6;
    color: #111827;
}

/* PRODUCT PAGE */
.product-page {
    display: grid;
    grid-template-columns: 1.2fr 1.4fr;
    gap: 24px;
    margin-top: 16px;
}

.product-image-large {
    background: #fff;
    border-radius: 14px;
    padding: 16px;
    box-shadow: 0 1px 4px rgba(0,0,0,0.04);
}

.placeholder-lg {
    height: 260px;
    border-radius: 12px;
    background: linear-gradient(135deg, #e5e7eb, #d1d5db);
}

.product-info {
    background: #fff;
    border-radius: 14px;
    padding: 16px;
    box-shadow: 0 1px 4px rgba(0,0,0,0.04);
}

.product-info h1 {
    font-size: 20px;
    margin-bottom: 4px;
}

.product-price-lg {
    margin-top: 8px;
    font-size: 20px;
    font-weight: 700;
}

.product-price-lg span {
    font-size: 14px;
    color: var(--muted);
    text-decoration: line-through;
    margin-right: 4px;
}

/* GENERAL PANELS */
.product-panel {
    background: #fff;
    border-radius: 14px;
    padding: 14px 16px;
    box-shadow: 0 1px 4px rgba(0,0,0,0.04);
}

/* MUTED TEXT */
.muted {
    color: var(--muted);
    font-size: 13px;
}

/* FILTER FORMS (FRONT) */
.filter-form {
    margin: 12px 0 18px;
    padding: 10px 12px;
    border-radius: 10px;
    background: #fff;
    border: 1px solid #eee;
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    align-items: center;
}

.filter-form input[type="text"],
.filter-form input[type="number"],
.filter-form select {
    padding: 6px 10px;
    border-radius: 8px;
    border: 1px solid #ddd;
    font-size: 13px;
}

/* CART */
.table-box {
    background: #fff;
    border-radius: 12px;
    padding: 10px 12px;
    box-shadow: 0 1px 4px rgba(0,0,0,0.04);
}

.cart-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.cart-table th,
.cart-table td {
    padding: 6px 4px;
    border-bottom: 1px solid #f3f4f6;
}

.cart-table th {
    text-align: left;
    font-weight: 600;
}

.cart-actions {
    margin-top: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

/* CHECKOUT */
.checkout-layout {
    display: grid;
    grid-template-columns: minmax(0, 1.6fr) minmax(0, 1.2fr);
    gap: 16px;
    margin-top: 16px;
}

.checkout-form-panel,
.checkout-summary-panel {
    background: #fff;
    border-radius: 14px;
    padding: 14px 16px;
    box-shadow: 0 1px 4px rgba(0,0,0,0.04);
}

.checkout-form-panel label {
    font-size: 13px;
    font-weight: 600;
    display: block;
    margin-bottom: 2px;
}

.checkout-form-panel input,
.checkout-form-panel textarea {
    width: 100%;
    padding: 6px 8px;
    border-radius: 8px;
    border: 1px solid #ddd;
    font-size: 13px;
}

.checkout-summary-item {
    display: flex;
    justify-content: space-between;
    gap: 10px;
    padding: 6px 0;
    border-bottom: 1px solid #f3f4f6;
}

.checkout-summary-total {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-top: 8px;
    padding-top: 8px;
    border-top: 1px solid #e5e7eb;
}

/* FOOTER */
.site-footer {
    border-top: 1px solid #e5e7eb;
    margin-top: 32px;
    padding: 18px 16px 26px;
    background: #fff;
}

.footer-inner {
    max-width: 1200px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: 2fr 1fr 1fr;
    gap: 20px;
}

.footer-column h4,
.footer-column h5 {
    font-size: 14px;
    margin-bottom: 6px;
}

.footer-column ul {
    list-style: none;
    padding-left: 0;
}

.footer-column li {
    margin-bottom: 4px;
}

.footer-column a {
    font-size: 13px;
    color: #374151;
}

/* ADMIN LAYOUT */
.admin-container {
    max-width: 1200px;
    margin: 16px auto 40px;
    padding: 0 16px;
}

.admin-header-bar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 16px;
    flex-wrap: wrap;
    margin-bottom: 16px;
}

.admin-logo {
    font-weight: 700;
    font-size: 18px;
    color: var(--primary-dark);
}

.admin-subtitle {
    font-size: 12px;
    color: var(--muted);
}

.admin-nav {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.admin-main {
    min-height: 60vh;
}

.admin-footer {
    margin-top: 20px;
    padding-top: 10px;
    border-top: 1px solid #e5e7eb;
    text-align: center;
    font-size: 12px;
    color: var(--muted);
}

/* ADMIN BUTTONS */
.admin-btn,
.admin-btn-secondary {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 6px 12px;
    border-radius: 999px;
    font-size: 13px;
    cursor: pointer;
    border: none;
}

.admin-btn {
    background: var(--primary);
    color: #fff;
    font-weight: 600;
}

.admin-btn-secondary {
    background: #f3f4f6;
    color: #111827;
    border: 1px solid #e5e7eb;
}

/* ADMIN TABLES */
.admin-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.admin-table th,
.admin-table td {
    padding: 6px 6px;
    border-bottom: 1px solid #e5e7eb;
    text-align: left;
}

.admin-table th {
    font-weight: 600;
    background: #f9fafb;
}

/* ADMIN STATS */
.admin-stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 12px;
    margin-bottom: 20px;
}

.admin-stat-card {
    padding: 12px 14px;
}

.admin-stat-label {
    font-size: 12px;
    color: #6b7280;
}

.admin-stat-value {
    font-size: 24px;
    font-weight: 700;
    margin-top: 4px;
}

.admin-stat-sub {
    font-size: 11px;
    color: #9ca3af;
    margin-top: 2px;
}

/* PILLS FOR STATUS */
.pill-success {
    background: #dcfce7;
    color: #166534;
    border-color: #bbf7d0;
}

.pill-warning {
    background: #fef3c7;
    color: #92400e;
    border-color: #fde68a;
}

.pill-danger {
    background: #fee2e2;
    color: #b91c1c;
    border-color: #fecaca;
}

.pill-muted {
    background: #f3f4f6;
    color: #4b5563;
    border-color: #e5e7eb;
}

/* FORMS (ADMIN GENERIC) */
.product-panel input[type="text"],
.product-panel input[type="number"],
.product-panel input[type="email"],
.product-panel input[type="password"],
.product-panel textarea,
.product-panel select {
    width: 100%;
    padding: 6px 8px;
    border-radius: 8px;
    border: 1px solid #ddd;
    font-size: 13px;
}

.product-panel label {
    font-size: 13px;
    font-weight: 600;
    display: block;
    margin-bottom: 2px;
}

/* RESPONSIVE */
@media (max-width: 900px) {
    .layout {
        grid-template-columns: 1fr;
    }

    .categories {
        display: none;
    }

    .hero {
        grid-template-columns: 1fr;
    }

    .product-page {
        grid-template-columns: 1fr;
    }

    .checkout-layout {
        grid-template-columns: 1fr;
    }

    .footer-inner {
        grid-template-columns: 1fr 1fr;
    }
}

@media (max-width: 640px) {
    .nav-container {
        flex-wrap: wrap;
    }

    .search {
        order: 3;
        width: 100%;
    }

    .footer-inner {
        grid-template-columns: 1fr;
    }
}
