<?php
// admin/update_product.php
require __DIR__ . '/../db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    $_SESSION['flash'] = [
        'type'    => 'error',
        'message' => 'Invalid product ID.',
    ];
    header("Location: /admin/products_list.php");
    exit;
}

// Simple slugify
function slugify(string $text): string {
    $text = strtolower(trim($text));
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    if (empty($text)) {
        return 'product-' . time();
    }
    return $text;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: /admin/edit_product.php?id=" . $id);
    exit;
}

$name        = trim($_POST['name'] ?? '');
$category_id = (int)($_POST['category_id'] ?? 0);
$price       = (float)($_POST['price'] ?? 0);
$old_price   = $_POST['old_price'] !== '' ? (float)$_POST['old_price'] : null;
$short_meta  = trim($_POST['short_meta'] ?? '');
$description = trim($_POST['description'] ?? '');
$main_image  = trim($_POST['main_image'] ?? '');
$tags        = trim($_POST['tags'] ?? '');
$condition   = trim($_POST['condition'] ?? '');
$is_featured = !empty($_POST['is_featured']) ? 1 : 0;
$is_active   = !empty($_POST['is_active']) ? 1 : 0;

$errors = [];

if ($name === '') {
    $errors[] = "Product name is required.";
}
if ($category_id <= 0) {
    $errors[] = "Category is required.";
}
if ($price <= 0) {
    $errors[] = "Price must be greater than zero.";
}

if (!empty($errors)) {
    $_SESSION['flash'] = [
        'type'    => 'error',
        'message' => implode(' ', $errors),
    ];
    header("Location: /admin/edit_product.php?id=" . $id);
    exit;
}

// Build slug (optional: keep existing if any)
$slug = slugify($name);

$stmt = $pdo->prepare("
    UPDATE products
    SET
        name        = :name,
        slug        = :slug,
        category_id = :category_id,
        price       = :price,
        old_price   = :old_price,
        short_meta  = :short_meta,
        description = :description,
        main_image  = :main_image,
        tags        = :tags,
        condition   = :condition,
        is_featured = :is_featured,
        is_active   = :is_active
    WHERE id = :id
");

$stmt->execute([
    ':name'        => $name,
    ':slug'        => $slug,
    ':category_id' => $category_id,
    ':price'       => $price,
    ':old_price'   => $old_price,
    ':short_meta'  => $short_meta ?: null,
    ':description' => $description ?: null,
    ':main_image'  => $main_image ?: null,
    ':tags'        => $tags ?: null,
    ':condition'   => $condition ?: null,
    ':is_featured' => $is_featured,
    ':is_active'   => $is_active,
    ':id'          => $id,
]);

$_SESSION['flash'] = [
    'type'    => 'success',
    'message' => 'Product updated successfully.',
];

header("Location: /admin/products_list.php");
exit;
