<?php
// admin/products_list.php
$pageTitle = "Products – CompNet Admin";
require __DIR__ . '/../db.php';
require __DIR__ . '/header.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Fetch categories for mapping
$categoriesStmt = $pdo->query("SELECT id, name FROM categories ORDER BY name ASC");
$categoriesMap = [];
foreach ($categoriesStmt as $c) {
    $categoriesMap[$c['id']] = $c['name'];
}

// Fetch products with category
$stmt = $pdo->query("
    SELECT p.*, c.name AS category_name
    FROM products p
    LEFT JOIN categories c ON p.category_id = c.id
    ORDER BY p.created_at DESC
");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h1>Products</h1>
<p class="muted" style="margin-bottom:12px;">Manage products shown on the storefront.</p>

<?php if (!empty($_SESSION['flash'])): ?>
    <div class="flash flash-<?= htmlspecialchars($_SESSION['flash']['type']) ?>">
        <?= htmlspecialchars($_SESSION['flash']['message']) ?>
    </div>
    <?php unset($_SESSION['flash']); ?>
<?php endif; ?>

<div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center;gap:10px;flex-wrap:wrap;">
    <a href="/admin/add_product.php" class="admin-btn" style="text-decoration:none;">+ Add Product</a>
</div>

<div class="table-box">
    <table class="admin-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Category</th>
                <th>Price (KSh)</th>
                <th>Featured</th>
                <th>Active</th>
                <th>Created</th>
                <th style="width:140px;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($products)): ?>
                <tr>
                    <td colspan="8" style="text-align:center;padding:16px;color:#777;">
                        No products found. Click "Add Product" to create one.
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($products as $p): ?>
                    <tr>
                        <td><?= (int)$p['id'] ?></td>
                        <td><?= htmlspecialchars($p['name']) ?></td>
                        <td><?= htmlspecialchars($p['category_name'] ?? '—') ?></td>
                        <td><?= number_format($p['price']) ?></td>
                        <td>
                            <span class="pill <?= $p['is_featured'] ? 'pill-success' : 'pill-muted' ?>">
                                <?= $p['is_featured'] ? 'Yes' : 'No' ?>
                            </span>
                        </td>
                        <td>
                            <span class="pill <?= $p['is_active'] ? 'pill-success' : 'pill-danger' ?>">
                                <?= $p['is_active'] ? 'Active' : 'Hidden' ?>
                            </span>
                        </td>
                        <td><?= htmlspecialchars($p['created_at']) ?></td>
                        <td>
                            <a href="/admin/edit_product.php?id=<?= $p['id'] ?>" style="font-size:13px;">Edit</a> |
                            <a href="/product/<?= $p['id'] ?>" target="_blank" style="font-size:13px;">View</a> |
                            <a href="/admin/delete_product.php?id=<?= $p['id'] ?>"
                               style="font-size:13px;color:#b91c1c;"
                               onclick="return confirm('Delete this product?');">
                                Delete
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require __DIR__ . '/footer.php'; ?>
