<?php
// admin/orders_list.php
$pageTitle = "Orders – CompNet Admin";
require __DIR__ . '/../db.php';
require __DIR__ . '/header.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$statusFilter  = trim($_GET['status'] ?? '');
$paymentFilter = trim($_GET['pay'] ?? '');

$sql = "
    SELECT
        o.*,
        COUNT(oi.id) AS items_count
    FROM orders o
    LEFT JOIN order_items oi ON oi.order_id = o.id
";
$params = [];
$where = [];

if ($statusFilter !== '') {
    $where[] = "o.status = :status";
    $params[':status'] = $statusFilter;
}
if ($paymentFilter !== '') {
    $where[] = "o.payment_status = :pay";
    $params[':pay'] = $paymentFilter;
}

if ($where) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

$sql .= " GROUP BY o.id ORDER BY o.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

$statuses        = ['pending', 'confirmed', 'shipped', 'completed', 'cancelled'];
$paymentStatuses = ['unpaid', 'paid_mpesa', 'paid_cash', 'refunded'];
?>

<h1>Orders</h1>
<p class="muted" style="margin-bottom:16px;">View and filter customer orders.</p>

<?php if (!empty($_SESSION['flash'])): ?>
    <div class="flash flash-<?= htmlspecialchars($_SESSION['flash']['type']) ?>">
        <?= htmlspecialchars($_SESSION['flash']['message']) ?>
    </div>
    <?php unset($_SESSION['flash']); ?>
<?php endif; ?>

<div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center;gap:10px;flex-wrap:wrap;">
    <form method="get" style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
        <label style="font-size:13px;">Order status:</label>
        <select name="status" style="padding:6px 10px;border-radius:8px;border:1px solid #ddd;font-size:13px;">
            <option value="">All</option>
            <?php foreach ($statuses as $st): ?>
                <option value="<?= $st ?>" <?= $st === $statusFilter ? 'selected' : '' ?>>
                    <?= ucfirst($st) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <label style="font-size:13px;">Payment:</label>
        <select name="pay" style="padding:6px 10px;border-radius:8px;border:1px solid #ddd;font-size:13px;">
            <option value="">All</option>
            <?php foreach ($paymentStatuses as $pst): ?>
                <option value="<?= $pst ?>" <?= $pst === $paymentFilter ? 'selected' : '' ?>>
                    <?php
                    if ($pst === 'paid_mpesa') echo 'Paid (MPESA)';
                    elseif ($pst === 'paid_cash') echo 'Paid (Cash)';
                    elseif ($pst === 'refunded') echo 'Refunded';
                    else echo 'Unpaid';
                    ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button type="submit" class="admin-btn-secondary">Filter</button>
        <a href="/admin/orders_list.php" class="admin-btn-secondary" style="text-decoration:none;">Clear</a>
    </form>

    <div>
        <a href="orders_export.php<?=
            ($statusFilter !== '' || $paymentFilter !== '')
                ? '?' . http_build_query(array_filter(['status' => $statusFilter, 'pay' => $paymentFilter]))
                : ''
        ?>"
           class="admin-btn-secondary"
           style="text-decoration:none;">
            Export CSV
        </a>
    </div>
</div>

<div class="table-box">
    <table class="admin-table">
        <thead>
            <tr>
                <th>#</th>
                <th>Placed</th>
                <th>Customer</th>
                <th>Phone</th>
                <th>Town</th>
                <th>Items</th>
                <th>Total (KSh)</th>
                <th>Status</th>
                <th>Payment</th>
                <th style="width:90px;">Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php if (empty($orders)): ?>
            <tr>
                <td colspan="10" style="text-align:center;padding:16px;color:#777;">
                    No orders found.
                </td>
            </tr>
        <?php else: ?>
            <?php foreach ($orders as $o): ?>
                <tr>
                    <td>#<?= (int)$o['id'] ?></td>
                    <td><?= htmlspecialchars($o['created_at']) ?></td>
                    <td><?= htmlspecialchars($o['customer_name']) ?></td>
                    <td><?= htmlspecialchars($o['phone']) ?></td>
                    <td><?= htmlspecialchars($o['town'] ?? '-') ?></td>
                    <td><?= (int)$o['items_count'] ?></td>
                    <td><?= number_format($o['total_amount']) ?></td>
                    <td>
                        <span class="pill pill-muted">
                            <?= htmlspecialchars(ucfirst($o['status'])) ?>
                        </span>
                    </td>
                    <td>
                        <?php
                        $payClass = 'pill-muted';
                        $payLabel = 'Unpaid';

                        if ($o['payment_status'] === 'paid_mpesa') {
                            $payClass = 'pill-success';
                            $payLabel = 'Paid (MPESA)';
                        } elseif ($o['payment_status'] === 'paid_cash') {
                            $payClass = 'pill-success';
                            $payLabel = 'Paid (Cash)';
                        } elseif ($o['payment_status'] === 'refunded') {
                            $payClass = 'pill-danger';
                            $payLabel = 'Refunded';
                        } elseif ($o['payment_status'] === 'unpaid') {
                            $payClass = 'pill-warning';
                            $payLabel = 'Unpaid';
                        }
                        ?>
                        <span class="pill <?= $payClass ?>">
                            <?= htmlspecialchars($payLabel) ?>
                        </span>
                    </td>
                    <td>
                        <a href="/admin/order_view.php?id=<?= $o['id'] ?>"
                           style="font-size:13px;color:#0070c9;">
                            View
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require __DIR__ . '/footer.php'; ?>
