<?php
// admin/orders_export.php
require __DIR__ . '/../db.php';

$statusFilter  = trim($_GET['status'] ?? '');
$paymentFilter = trim($_GET['pay'] ?? '');

$sql = "
    SELECT
        o.id,
        o.created_at,
        o.customer_name,
        o.phone,
        o.email,
        o.town,
        o.address,
        o.total_amount,
        o.status,
        o.payment_status,
        o.payment_reference,
        o.paid_at
    FROM orders o
";
$params = [];
$where = [];

if ($statusFilter !== '') {
    $where[] = "o.status = :status";
    $params[':status'] = $statusFilter;
}
if ($paymentFilter !== '') {
    $where[] = "o.payment_status = :pay";
    $params[':pay'] = $paymentFilter;
}

if ($where) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

$sql .= " ORDER BY o.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

$filename = "orders_" . date('Ymd_His') . ".csv";

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=' . $filename);

$output = fopen('php://output', 'w');

fputcsv($output, [
    'Order ID',
    'Date',
    'Customer Name',
    'Phone',
    'Email',
    'Town',
    'Address',
    'Total Amount',
    'Order Status',
    'Payment Status',
    'Payment Reference',
    'Paid At',
]);

foreach ($orders as $o) {
    fputcsv($output, [
        $o['id'],
        $o['created_at'],
        $o['customer_name'],
        $o['phone'],
        $o['email'],
        $o['town'],
        $o['address'],
        $o['total_amount'],
        $o['status'],
        $o['payment_status'],
        $o['payment_reference'],
        $o['paid_at'],
    ]);
}

fclose($output);
exit;
