<?php
// admin/login.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require __DIR__ . '/../db.php';
require __DIR__ . '/config.php';

// Already logged in? Go to dashboard
if (!empty($_SESSION['admin_logged_in'])) {
    header("Location: /admin/index.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($username === ADMIN_USERNAME && password_verify($password, ADMIN_PASSWORD_HASH)) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username']  = $username;

        header("Location: /admin/index.php");
        exit;
    } else {
        $error = "Invalid admin username or password.";
    }
}

// Allow this page to load without being logged in
$skipAuth  = true;
$pageTitle = "Admin Login – CompNet";
require __DIR__ . '/header.php';
?>

<h1>Admin Login</h1>
<p class="muted" style="margin-bottom:16px;">Sign in to manage products, categories and orders.</p>

<?php if ($error): ?>
    <div class="flash flash-error" style="max-width:420px;">
        <?= htmlspecialchars($error) ?>
    </div>
<?php endif; ?>

<div class="product-panel" style="max-width:420px;margin-top:16px;">
    <form method="post" style="display:flex;flex-direction:column;gap:10px;">
        <div>
            <label style="font-size:13px;font-weight:600;">Username</label>
            <input type="text"
                   name="username"
                   required
                   style="width:100%;padding:8px 10px;border-radius:8px;border:1px solid #ddd;margin-top:4px;"
                   value="<?= htmlspecialchars($_POST['username'] ?? '') ?>">
        </div>

        <div>
            <label style="font-size:13px;font-weight:600;">Password</label>
            <input type="password"
                   name="password"
                   required
                   style="width:100%;padding:8px 10px;border-radius:8px;border:1px solid #ddd;margin-top:4px;">
        </div>

        <div style="display:flex;justify-content:space-between;align-items:center;margin-top:6px;">
            <a href="/" style="font-size:13px;color:#0070c9;text-decoration:none;">← Back to site</a>
            <button type="submit" class="admin-btn" style="border:none;">Login</button>
        </div>
    </form>
</div>

<?php require __DIR__ . '/footer.php'; ?>
