<?php
// admin/header.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require __DIR__ . '/config.php';

// Default title
if (!isset($pageTitle)) {
    $pageTitle = "Admin – CompNet";
}

// Protect admin pages unless $skipAuth is explicitly set
if (empty($skipAuth) && empty($_SESSION['admin_logged_in'])) {
    header("Location: /admin/login.php");
    exit;
}

$adminName = $_SESSION['admin_username'] ?? 'Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>

<div class="admin-container">
    <header class="admin-header-bar">
        <div>
            <div class="admin-logo">CompNet Admin</div>
            <div class="admin-subtitle">Logged in as <?= htmlspecialchars($adminName) ?></div>
        </div>
        <nav class="admin-nav">
            <a href="/admin/index.php" class="admin-btn-secondary">Dashboard</a>
            <a href="/admin/products_list.php" class="admin-btn-secondary">Products</a>
            <a href="/admin/categories_list.php" class="admin-btn-secondary">Categories</a>
            <a href="/admin/orders_list.php" class="admin-btn-secondary">Orders</a>
            <a href="/" class="admin-btn-secondary">View Site</a>
            <?php if (!empty($_SESSION['admin_logged_in'])): ?>
                <a href="/admin/logout.php" class="admin-btn-secondary">Logout</a>
            <?php endif; ?>
        </nav>
    </header>

    <main class="admin-main">
