<?php
// admin/edit_product.php
$pageTitle = "Edit Product – CompNet Admin";
require __DIR__ . '/../db.php';
require __DIR__ . '/header.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    echo "<h1>Invalid product ID.</h1>";
    require __DIR__ . '/footer.php';
    exit;
}

// Fetch categories
$categoriesStmt = $pdo->query("SELECT id, name FROM categories ORDER BY name ASC");
$categories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch product
$stmt = $pdo->prepare("SELECT * FROM products WHERE id = :id");
$stmt->execute([':id' => $id]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$product) {
    echo "<h1>Product not found.</h1>";
    require __DIR__ . '/footer.php';
    exit;
}
?>

<h1>Edit Product</h1>

<div class="product-panel">
    <form action="/admin/update_product.php?id=<?= $product['id'] ?>" method="post"
          style="display:grid;grid-template-columns:1fr 1fr;gap:12px;">
        <div style="grid-column:1 / -1;">
            <label>Name *</label>
            <input type="text" name="name" required
                   value="<?= htmlspecialchars($product['name']) ?>">
        </div>

        <div>
            <label>Category *</label>
            <select name="category_id" required>
                <option value="">Select category</option>
                <?php foreach ($categories as $c): ?>
                    <option value="<?= $c['id'] ?>" <?= $product['category_id'] == $c['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($c['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label>Condition</label>
            <select name="condition">
                <option value="">—</option>
                <?php $cond = $product['condition'] ?? ''; ?>
                <option value="new"    <?= $cond === 'new' ? 'selected' : '' ?>>New</option>
                <option value="ex-uk"  <?= $cond === 'ex-uk' ? 'selected' : '' ?>>Ex-UK</option>
                <option value="refurb" <?= $cond === 'refurb' ? 'selected' : '' ?>>Refurbished</option>
                <option value="used"   <?= $cond === 'used' ? 'selected' : '' ?>>Used</option>
            </select>
        </div>

        <div>
            <label>Price (KSh) *</label>
            <input type="number" step="0.01" name="price" required
                   value="<?= htmlspecialchars($product['price']) ?>">
        </div>

        <div>
            <label>Old Price (KSh)</label>
            <input type="number" step="0.01" name="old_price"
                   value="<?= htmlspecialchars($product['old_price']) ?>">
        </div>

        <div>
            <label>Main Image URL</label>
            <input type="text" name="main_image"
                   value="<?= htmlspecialchars($product['main_image']) ?>">
        </div>

        <div style="grid-column:1 / -1;">
            <label>Short Meta (summary)</label>
            <input type="text" name="short_meta"
                   value="<?= htmlspecialchars($product['short_meta']) ?>">
        </div>

        <div style="grid-column:1 / -1;">
            <label>Tags (comma-separated)</label>
            <input type="text" name="tags"
                   value="<?= htmlspecialchars($product['tags']) ?>">
        </div>

        <div style="grid-column:1 / -1;">
            <label>Description</label>
            <textarea name="description" rows="5"><?= htmlspecialchars($product['description']) ?></textarea>
        </div>

        <div>
            <label>
                <input type="checkbox" name="is_featured" value="1"
                       <?= $product['is_featured'] ? 'checked' : '' ?>>
                Featured
            </label>
        </div>

        <div>
            <label>
                <input type="checkbox" name="is_active" value="1"
                       <?= $product['is_active'] ? 'checked' : '' ?>>
                Active
            </label>
        </div>

        <div style="grid-column:1 / -1;display:flex;justify-content:space-between;align-items:center;margin-top:10px;">
            <a href="/admin/products_list.php" class="admin-btn-secondary" style="text-decoration:none;">← Back</a>
            <button type="submit" class="admin-btn">Update Product</button>
        </div>
    </form>
</div>

<?php require __DIR__ . '/footer.php'; ?>
