<?php
// admin/edit_category.php
$pageTitle = "Edit Category – CompNet Admin";
require __DIR__ . '/../db.php';
require __DIR__ . '/header.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    echo "<h1>Invalid category ID.</h1>";
    require __DIR__ . '/footer.php';
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM categories WHERE id = :id");
$stmt->execute([':id' => $id]);
$category = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$category) {
    echo "<h1>Category not found.</h1>";
    require __DIR__ . '/footer.php';
    exit;
}

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $slug = trim($_POST['slug'] ?? '');

    if ($name === '') {
        $errors[] = "Name is required.";
    }

    if ($slug === '') {
        $slug = $category['slug']; // keep existing or you could re-slugify
    }

    if (empty($errors)) {
        $stmtUpd = $pdo->prepare("UPDATE categories SET name = :name, slug = :slug WHERE id = :id");
        try {
            $stmtUpd->execute([
                ':name' => $name,
                ':slug' => $slug,
                ':id'   => $id,
            ]);
            $_SESSION['flash'] = [
                'type'    => 'success',
                'message' => 'Category updated.',
            ];
            header("Location: /admin/categories_list.php");
            exit;
        } catch (PDOException $e) {
            $errors[] = "Failed to update category. Slug may already exist.";
        }
    }
}
?>

<h1>Edit Category</h1>

<?php if (!empty($errors)): ?>
    <div class="flash flash-error">
        <?= htmlspecialchars(implode(' ', $errors)) ?>
    </div>
<?php endif; ?>

<div class="product-panel" style="max-width:480px;">
    <form method="post" style="display:flex;flex-direction:column;gap:10px;">
        <div>
            <label>Name *</label>
            <input type="text" name="name" required
                   value="<?= htmlspecialchars($_POST['name'] ?? $category['name']) ?>">
        </div>
        <div>
            <label>Slug</label>
            <input type="text" name="slug"
                   value="<?= htmlspecialchars($_POST['slug'] ?? $category['slug']) ?>">
        </div>

        <div style="display:flex;justify-content:space-between;align-items:center;margin-top:8px;">
            <a href="/admin/categories_list.php" class="admin-btn-secondary" style="text-decoration:none;">← Back</a>
            <button type="submit" class="admin-btn">Update Category</button>
        </div>
    </form>
</div>

<?php require __DIR__ . '/footer.php'; ?>
