<?php
// admin/delete_product.php
require __DIR__ . '/../db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id <= 0) {
    $_SESSION['flash'] = [
        'type'    => 'error',
        'message' => 'Invalid product ID.',
    ];
    header("Location: /admin/products_list.php");
    exit;
}

// Optional: you can prevent delete if product is used in order_items
// For now we simply delete.
$stmt = $pdo->prepare("DELETE FROM products WHERE id = :id");
$stmt->execute([':id' => $id]);

$_SESSION['flash'] = [
    'type'    => 'success',
    'message' => 'Product deleted.',
];

header("Location: /admin/products_list.php");
exit;
