<?php
// admin/delete_category.php
require __DIR__ . '/../db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id <= 0) {
    $_SESSION['flash'] = [
        'type'    => 'error',
        'message' => 'Invalid category ID.',
    ];
    header("Location: /admin/categories_list.php");
    exit;
}

// Optionally: reassign products to a default category before delete
// For now: allow delete; products will have broken foreign key unless ON DELETE CASCADE or you handle separately.

try {
    $stmt = $pdo->prepare("DELETE FROM categories WHERE id = :id");
    $stmt->execute([':id' => $id]);

    $_SESSION['flash'] = [
        'type'    => 'success',
        'message' => 'Category deleted.',
    ];
} catch (PDOException $e) {
    $_SESSION['flash'] = [
        'type'    => 'error',
        'message' => 'Failed to delete category. It may still have products linked.',
    ];
}

header("Location: /admin/categories_list.php");
exit;
