8<?php
// admin/create_category.php
$pageTitle = "Add Category – CompNet Admin";
require __DIR__ . '/../db.php';
require __DIR__ . '/header.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$errors = [];

function slugify_cat(string $text): string {
    $text = strtolower(trim($text));
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    if (empty($text)) {
        return 'category-' . time();
    }
    return $text;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $slug = trim($_POST['slug'] ?? '');

    if ($name === '') {
        $errors[] = "Category name is required.";
    }

    if ($slug === '') {
        $slug = slugify_cat($name);
    }

    if (empty($errors)) {
        $stmt = $pdo->prepare("INSERT INTO categories (name, slug) VALUES (:name, :slug)");
        try {
            $stmt->execute([
                ':name' => $name,
                ':slug' => $slug,
            ]);

            $_SESSION['flash'] = [
                'type'    => 'success',
                'message' => 'Category created successfully.',
            ];
            header("Location: /admin/categories_list.php");
            exit;
        } catch (PDOException $e) {
            $errors[] = "Failed to create category. Slug may already exist.";
        }
    }
}
?>

<h1>Add Category</h1>

<?php if (!empty($errors)): ?>
    <div class="flash flash-error">
        <?= htmlspecialchars(implode(' ', $errors)) ?>
    </div>
<?php endif; ?>

<div class="product-panel" style="max-width:480px;">
    <form method="post" style="display:flex;flex-direction:column;gap:10px;">
        <div>
            <label>Name *</label>
            <input type="text" name="name" required
                   value="<?= htmlspecialchars($_POST['name'] ?? '') ?>">
        </div>
        <div>
            <label>Slug (optional)</label>
            <input type="text" name="slug"
                   placeholder="laptops, accessories, networking"
                   value="<?= htmlspecialchars($_POST['slug'] ?? '') ?>">
        </div>

        <div style="display:flex;justify-content:space-between;align-items:center;margin-top:8px;">
            <a href="/admin/categories_list.php" class="admin-btn-secondary" style="text-decoration:none;">← Back</a>
            <button type="submit" class="admin-btn">Save Category</button>
        </div>
    </form>
</div>

<?php require __DIR__ . '/footer.php'; ?>
