<?php
// admin/categories_list.php
$pageTitle = "Categories – CompNet Admin";
require __DIR__ . '/../db.php';
require __DIR__ . '/header.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$stmt = $pdo->query("
    SELECT c.*,
           (SELECT COUNT(*) FROM products p WHERE p.category_id = c.id) AS products_count
    FROM categories c
    ORDER BY c.name ASC
");
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h1>Categories</h1>
<p class="muted" style="margin-bottom:12px;">Manage product categories.</p>

<?php if (!empty($_SESSION['flash'])): ?>
    <div class="flash flash-<?= htmlspecialchars($_SESSION['flash']['type']) ?>">
        <?= htmlspecialchars($_SESSION['flash']['message']) ?>
    </div>
    <?php unset($_SESSION['flash']); ?>
<?php endif; ?>

<div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center;gap:10px;flex-wrap:wrap;">
    <a href="/admin/create_category.php" class="admin-btn" style="text-decoration:none;">+ Add Category</a>
</div>

<div class="table-box">
    <table class="admin-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Slug</th>
                <th>Products</th>
                <th>Created</th>
                <th style="width:140px;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($categories)): ?>
                <tr>
                    <td colspan="6" style="text-align:center;padding:16px;color:#777;">
                        No categories found.
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($categories as $c): ?>
                    <tr>
                        <td><?= (int)$c['id'] ?></td>
                        <td><?= htmlspecialchars($c['name']) ?></td>
                        <td><?= htmlspecialchars($c['slug']) ?></td>
                        <td><?= (int)$c['products_count'] ?></td>
                        <td><?= htmlspecialchars($c['created_at']) ?></td>
                        <td>
                            <a href="/admin/edit_category.php?id=<?= $c['id'] ?>" style="font-size:13px;">Edit</a> |
                            <a href="/category/<?= htmlspecialchars($c['slug']) ?>" target="_blank" style="font-size:13px;">View</a> |
                            <a href="/admin/delete_category.php?id=<?= $c['id'] ?>"
                               style="font-size:13px;color:#b91c1c;"
                               onclick="return confirm('Delete this category? Products will lose their category.');">
                                Delete
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require __DIR__ . '/footer.php'; ?>
